unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  BaseMainDigestData, StdCtrls, ExtCtrls, stDERUtils, 
  stSecUtils;

type
  TfrmMain = class(TfrmBaseMainDigestData)
  private
    function GetHashClass: tHashClass; 
  public
    function DigestString(const aInput: OctetString): OctetString; override;
    function DigestFile(const aFilename: string): OctetString; override;
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

{ TfrmMain }

function TfrmMain.DigestFile(const aFilename: string): OctetString;
begin
  raise Exception.Create('Not supported: Use the DigestFile routine');
end;

function TfrmMain.DigestString(const aInput: OctetString): OctetString;
var
  lH: tHash;
begin
  lH := GetHashClass.CreateUnkeyed(False);
  try
    lH.HashData(Pointer(aInput)^,Length(aInput));
    lH.Done(nil);
    Result := lH.Digest;
  finally
    lH.Free;
  end;
end;

function TfrmMain.GetHashClass: tHashClass;
begin
  Result := MustFindHashClass(HashAlgorithm);
end;

end.
